#ifndef _3_AXIS_H
#define _3_AXIS_H

typedef struct
{
	unsigned x_axis_to_x_minus:1;							// y0
	unsigned x_axis_to_x_plus:1;							// y1
	
	unsigned y_axis_to_y_minus:1;							// y2
	unsigned y_axis_to_y_plus:1;							// y3
	
	unsigned z_axis_to_z_plus:1;							// y4
	unsigned z_axis_to_z_minus:1;							// y5
	
	unsigned magnet:1;										// y6
	
	unsigned reserve0:1;
	unsigned char reserve1;	//8 bit
	unsigned int reserve2;	//16 bit
	unsigned int reserve3;	//16 bit
} Actuator_t;

typedef struct
{
	unsigned x_axis_at_position_x_minus:1;					// x0
	unsigned x_axis_at_position_x_plus:1;					// x1
	unsigned x_axis_reference_position:1;					// x2
	
	unsigned y_axis_at_position_y_minus:1;					// x3
	unsigned y_axis_at_position_y_plus:1;					// x4
	unsigned y_axis_reference_position:1;					// x5
	
	unsigned z_axis_at_position_z_plus:1;					// x6
	unsigned z_axis_at_position_z_minus:1;					// x7
	
	unsigned proximity_switch:1;		         			// x8
	
	unsigned reserve0:7;
	unsigned int reserve1;
	unsigned int reserve2;
} Sensor_t;

#define SensorPointer (uint8_t *)&Sensors
#define ActuatorPointer (uint8_t *)&Actuators

extern Sensor_t Sensors;
extern Actuator_t Actuators;

#endif /* _3_AXIS_H */